import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Form, TextArea, Checkbox} from 'react-form';
import Text from "../Fields/Text/Text";
import DateTime from "../Fields/DateTime/DateTime";
import Loading from "../../Loading/Loading";
import {withApollo} from "react-apollo";
import {withRouter} from "react-router-dom";
import Permessions from "../../../permissions";

import RoleSelect from "../../Forms/Fields/RoleSelect/RoleSelect"

class UsersFormComponent extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
        this.onSubmit = this.onSubmit.bind(this);
    }

    onSubmit(values) {

        const {client, submitMutation, data} = this.props;

        this.setState({submitting: true});

        let variables = {
            utente: {
                ...values
            }
        };

        delete variables.utente.__typename;

        if(data && data.id) {
            variables.utente.id = data.id;
        }

        client.mutate({
            mutation: submitMutation,
            variables: variables,
        }).then(res => {
            if(this.props.onSubmitComplete) {
                this.props.onSubmitComplete();
            } else {
                this.props.history.goBack();
            }
        }).catch(err => {
            console.log(err);
            this.setState({
                submitting: false,
                error: true,
            });
        });
    }

    render() {
        const {
            data,
            readOnly
        } = this.props;

        if(data && data.loading) {
            return(<Loading/>);
        }

        return (
            <Form
                defaultValues={data ? data.utente : null}
                onSubmit={this.onSubmit}>
                {(formApi) => <form onSubmit={formApi.submitForm}>
                        <div className="row">
                            <div className="col">
                                <h5>Informazioni Utente</h5>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="id">Codice Fiscale</label>
                                    <Text
                                        readOnly={data && data.utente && data.utente.id ? true : false}
                                        field="id"
                                        id="id"
                                        type="text"
                                        className="form-control" />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="nome">Nome</label>
                                    <Text field="nome"
                                          readOnly={readOnly}
                                          id="nome"
                                          type="text"
                                          className="form-control" />
                                </div>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="cognome">Cognome</label>
                                    <Text field="cognome"
                                          readOnly={readOnly}
                                          id="cognome"
                                          type="text"
                                          className="form-control" />
                                </div>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="email">E-mail</label>
                                    <Text field="email"
                                          readOnly={readOnly}
                                          id="email"
                                          type="text"
                                          className="form-control" />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="scadenzaAccount">Scadenza Account</label>
                                    <DateTime readOnly={readOnly} id="scadenzaAccount" field="scadenzaAccount" />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="scadenzaAccount">Ruolo</label>

                                    <RoleSelect
                                        id="ruolo"
                                        field="ruolo.id"
                                        className="form-control"
                                        permissions={data ? data.utente.ruolo.permessi : []}
                                    />
                                </div>
                            </div>
                        </div>

                        {this.state.error && <div className="row">
                            <div className="col">
                                <div className="text-info text-center">Errore durante il salvataggio dell'utente</div>
                            </div>
                        </div>}

                        <div className="row">
                            <div className="col">
                                <button disabled={this.state.submitting} type="submit" className="btn btn-primary">
                                    {data && data.utente && data.utente.id ? "SALVA UTENTE" : "CREA NUOVO UTENTE"}
                                </button>
                            </div>
                        </div>
                </form>}
            </Form>);
    }
}

const UsersForm = withRouter(withApollo(UsersFormComponent));

UsersForm.defaultProps = {};

UsersForm.propTypes = {
    data: PropTypes.object,
    submitMutation: PropTypes.object.isRequired,
    errorMessage: PropTypes.string.isRequired,
    onSubmitComplete: PropTypes.func,
};

export default UsersForm;
